import request from '@/utils/request'

// 查询绩效考核方案 - 公共指标列表
export function listAssessPlanIndicatorCom(query) {
  return request({
    url: '/kpi/assessPlanIndicatorCom/list',
    method: 'get',
    params: query
  })
}

// 查询绩效考核方案 - 公共指标详细
export function getAssessPlanIndicatorCom(id) {
  return request({
    url: '/kpi/assessPlanIndicatorCom/' + id,
    method: 'get'
  })
}

// 新增绩效考核方案 - 公共指标
export function addAssessPlanIndicatorCom(data) {
  return request({
    url: '/kpi/assessPlanIndicatorCom',
    method: 'post',
    data: data
  })
}

// 修改绩效考核方案 - 公共指标
export function updateAssessPlanIndicatorCom(data) {
  return request({
    url: '/kpi/assessPlanIndicatorCom/edit',
    method: 'post',
    data: data
  })
}

// 删除绩效考核方案 - 公共指标
export function delAssessPlanIndicatorCom(id) {
  return request({
    url: '/kpi/assessPlanIndicatorCom/delete',
    method: 'post',
    data: id
  })
}
