import request from '@/utils/request'

// 查询绩效考核方案 - 考核指标 - 子项列表
export function listAssessPlanIndicatorItem(query) {
  return request({
    url: '/kpi/assessPlanIndicatorItem/list',
    method: 'get',
    params: query
  })
}

// 查询绩效考核方案 - 考核指标 - 子项详细
export function getAssessPlanIndicatorItem(id) {
  return request({
    url: '/kpi/assessPlanIndicatorItem/' + id,
    method: 'get'
  })
}

// 新增绩效考核方案 - 考核指标 - 子项
export function addAssessPlanIndicatorItem(data) {
  return request({
    url: '/kpi/assessPlanIndicatorItem',
    method: 'post',
    data: data
  })
}

// 修改绩效考核方案 - 考核指标 - 子项
export function updateAssessPlanIndicatorItem(data) {
  return request({
    url: '/kpi/assessPlanIndicatorItem/edit',
    method: 'post',
    data: data
  })
}

// 删除绩效考核方案 - 考核指标 - 子项
export function delAssessPlanIndicatorItem(id) {
  return request({
    url: '/kpi/assessPlanIndicatorItem/delete',
    method: 'post',
    data: id
  })
}
