import request from '@/utils/request'

// 查询数据源管理列表
export function listDatasource(query) {
  return request({
    url: '/kpi/datasource/list',
    method: 'get',
    params: query
  })
}

// 查询数据源管理详细
export function getDatasource(id) {
  return request({
    url: '/kpi/datasource/' + id,
    method: 'get'
  })
}

// 新增数据源管理
export function addDatasource(data) {
  return request({
    url: '/kpi/datasource',
    method: 'post',
    data: data
  })
}

// 修改数据源管理
export function updateDatasource(data) {
  return request({
    url: '/kpi/datasource/edit',
    method: 'post',
    data: data
  })
}

// 删除数据源管理
export function delDatasource(id) {
  return request({
    url: '/kpi/datasource/delete',
    method: 'post',
    data: id
  })
}

/**
 * 数据库连接测试
 * @param data
 */
export function testConnection(data) {
  return request({
    url: '/kpi/datasource/testConnection',
    method: 'post',
    data: data
  })
}
