import request from '@/utils/request'

// 查询结果集管理列表
export function listDatasourceResultSet(query) {
  return request({
    url: '/kpi/datasourceResultSet/list',
    method: 'get',
    params: query
  })
}

// 查询结果集管理详细
export function getDatasourceResultSet(id) {
  return request({
    url: '/kpi/datasourceResultSet/' + id,
    method: 'get'
  })
}

// 新增结果集管理
export function addDatasourceResultSet(data) {
  return request({
    url: '/kpi/datasourceResultSet',
    method: 'post',
    data: data
  })
}

// 修改结果集管理
export function updateDatasourceResultSet(data) {
  return request({
    url: '/kpi/datasourceResultSet/edit',
    method: 'post',
    data: data
  })
}

// 删除结果集管理
export function delDatasourceResultSet(id) {
  return request({
    url: '/kpi/datasourceResultSet/delete',
    method: 'post',
    data: id
  })
}

export function execSql(data) {
  return request({
    url: '/kpi/datasourceResultSet/execSql',
    method: 'post',
    data: data
  })
}

export function getSqlColumnById(data) {
  return request({
    url: '/kpi/datasourceResultSet/getSqlColumnById',
    method: 'post',
    data: data
  })
}
