import request from '@/utils/request'

// 查询绩效考核指标管理列表
export function listIndicator(query) {
  return request({
    url: '/kpi/indicator/list',
    method: 'get',
    params: query
  })
}

// 查询绩效考核指标管理详细
export function getIndicator(id) {
  return request({
    url: '/kpi/indicator/' + id,
    method: 'get'
  })
}

// 新增绩效考核指标管理
export function addIndicator(data) {
  return request({
    url: '/kpi/indicator',
    method: 'post',
    data: data
  })
}

// 修改绩效考核指标管理
export function updateIndicator(data) {
  return request({
    url: '/kpi/indicator/edit',
    method: 'post',
    data: data
  })
}

// 删除绩效考核指标管理
export function delIndicator(id) {
  return request({
    url: '/kpi/indicator/delete',
    method: 'post',
    data: id
  })
}
