import request from '@/utils/request'

// 查询绩效考核指标项管理列表
export function listInducatorItem(query) {
  return request({
    url: '/kpi/inducatorItem/list',
    method: 'get',
    params: query
  })
}

// 查询绩效考核指标项管理详细
export function getInducatorItem(id) {
  return request({
    url: '/kpi/inducatorItem/' + id,
    method: 'get'
  })
}

// 新增绩效考核指标项管理
export function addInducatorItem(data) {
  return request({
    url: '/kpi/inducatorItem',
    method: 'post',
    data: data
  })
}

// 修改绩效考核指标项管理
export function updateInducatorItem(data) {
  return request({
    url: '/kpi/inducatorItem/edit',
    method: 'post',
    data: data
  })
}

// 删除绩效考核指标项管理
export function delInducatorItem(id) {
  return request({
    url: '/kpi/inducatorItem/delete',
    method: 'post',
    data: id
  })
}
