import request from '@/utils/request'

// 查询绩效确认列表
export function listJxConfirm(query) {
  return request({
    url: '/kpi/jxConfirm/list',
    method: 'get',
    params: query
  })
}

// 查询绩效确认详细
export function getJxConfirm(id) {
  return request({
    url: '/kpi/jxConfirm/' + id,
    method: 'get'
  })
}

// 新增绩效确认
export function addJxConfirm(data) {
  return request({
    url: '/kpi/jxConfirm',
    method: 'post',
    data: data
  })
}

// 新增绩效确认
export function reAddJxConfirm(data) {
  return request({
    url: '/kpi/jxConfirm/reAddJxConfirm',
    method: 'post',
    data: data
  })
}

// 修改绩效确认
export function updateJxConfirm(data) {
  return request({
    url: '/kpi/jxConfirm/edit',
    method: 'post',
    data: data
  })
}

// 删除绩效确认
export function delJxConfirm(id) {
  return request({
    url: '/kpi/jxConfirm/delete',
    method: 'post',
    data: id
  })
}

// 查询绩效确认详细
export function confirmedIds(query) {
  return request({
    url: '/kpi/jxConfirm/confirmedIds',
    method: 'get',
    params: query
  })
}

export function dataListByConfirmId(query) {
  return request({
    url: '/kpi/jxConfirm/dataListByConfirmId',
    method: 'get',
    params: query
  })
}

// 查询绩效确认详细
export function listJxConfirmByAssessId(query) {
  return request({
    url: '/kpi/jxConfirm/listJxConfirmByAssessId',
    method: 'get',
    params: query
  })
}

// 新增绩效确认
export function addByCommand(data) {
  return request({
    url: '/kpi/jxConfirm/addByCommand',
    method: 'post',
    data: data
  })
}
