import request from '@/utils/request'

// 查询绩效评级配置列表
export function listJxRatingConfig(query) {
  return request({
    url: '/kpi/jxRatingConfig/list',
    method: 'get',
    params: query
  })
}

// 查询绩效评级配置详细
export function getJxRatingConfig(id) {
  return request({
    url: '/kpi/jxRatingConfig/' + id,
    method: 'get'
  })
}

// 新增绩效评级配置
export function addJxRatingConfig(data) {
  return request({
    url: '/kpi/jxRatingConfig',
    method: 'post',
    data: data
  })
}

// 修改绩效评级配置
export function updateJxRatingConfig(data) {
  return request({
    url: '/kpi/jxRatingConfig/edit',
    method: 'post',
    data: data
  })
}

// 删除绩效评级配置
export function delJxRatingConfig(id) {
  return request({
    url: '/kpi/jxRatingConfig/delete',
    method: 'post',
    data: id
  })
}
