import request from '@/utils/request'

// 查询手动指标管理列表
export function listManualIndicator(query) {
  return request({
    url: '/kpi/manualIndicator/list',
    method: 'get',
    params: query
  })
}

// 查询手动指标管理详细
export function getManualIndicator(id) {
  return request({
    url: '/kpi/manualIndicator/' + id,
    method: 'get'
  })
}

// 新增手动指标管理
export function addManualIndicator(data) {
  return request({
    url: '/kpi/manualIndicator',
    method: 'post',
    data: data
  })
}

// 修改手动指标管理
export function updateManualIndicator(data) {
  return request({
    url: '/kpi/manualIndicator/edit',
    method: 'post',
    data: data
  })
}

// 删除手动指标管理
export function delManualIndicator(id) {
  return request({
    url: '/kpi/manualIndicator/delete',
    method: 'post',
    data: id
  })
}

// 查询手动指标管理列表
export function listManualList(query) {
  return request({
    url: '/kpi/manualIndicator/listManualList',
    method: 'get',
    params: query
  })
}

// 删除手动指标管理
export function delManualList(data) {
  return request({
    url: '/kpi/manualIndicator/delManualList',
    method: 'post',
    data: data
  })
}
