import request from '@/utils/request'

// 查询绩效上级评分列表
export function listScore(query) {
  return request({
    url: '/kpi/score/list',
    method: 'get',
    params: query
  })
}

// 查询绩效上级评分详细
export function getScore(id) {
  return request({
    url: '/kpi/score/' + id,
    method: 'get'
  })
}

// 新增绩效上级评分
export function addScore(data) {
  return request({
    url: '/kpi/score',
    method: 'post',
    data: data
  })
}

// 修改绩效上级评分
export function updateScore(data) {
  return request({
    url: '/kpi/score/edit',
    method: 'post',
    data: data
  })
}

// 删除绩效上级评分
export function delScore(id) {
  return request({
    url: '/kpi/score/delete',
    method: 'post',
    data: id
  })
}
