import request from '@/utils/request'

// 查询绩效上级评分 - 结果列表
export function listScoreResult(query) {
  return request({
    url: '/kpi/scoreResult/list',
    method: 'get',
    params: query
  })
}

// 查询绩效上级评分 - 结果详细
export function getScoreResult(id) {
  return request({
    url: '/kpi/scoreResult/' + id,
    method: 'get'
  })
}

// 新增绩效上级评分 - 结果
export function addScoreResult(data) {
  return request({
    url: '/kpi/scoreResult',
    method: 'post',
    data: data
  })
}

// 修改绩效上级评分 - 结果
export function updateScoreResult(data) {
  return request({
    url: '/kpi/scoreResult/edit',
    method: 'post',
    data: data
  })
}

// 删除绩效上级评分 - 结果
export function delScoreResult(id) {
  return request({
    url: '/kpi/scoreResult/delete',
    method: 'post',
    data: id
  })
}

export function ratingEmployeeList(data) {
  return request({
    url: '/kpi/scoreResult/ratingEmployeeList',
    method: 'post',
    data: data
  })
}

export function getScoreResultDetail(data) {
  return request({
    url: '/kpi/scoreResult/getScoreResultDetail',
    method: 'post',
    data: data
  })
}
