import request from '@/utils/request'

// 查询绩效制度管理列表
export function listSystemManagement(query) {
  return request({
    url: '/kpi/systemManagement/list',
    method: 'get',
    params: query
  })
}

// 查询绩效制度管理详细
export function getSystemManagement(id) {
  return request({
    url: '/kpi/systemManagement/' + id,
    method: 'get'
  })
}

// 新增绩效制度管理
export function addSystemManagement(data) {
  return request({
    url: '/kpi/systemManagement',
    method: 'post',
    data: data
  })
}

// 修改绩效制度管理
export function updateSystemManagement(data) {
  return request({
    url: '/kpi/systemManagement/edit',
    method: 'post',
    data: data
  })
}

// 删除绩效制度管理
export function delSystemManagement(id) {
  return request({
    url: '/kpi/systemManagement/delete',
    method: 'post',
    data: id
  })
}
