import request from '@/utils/request'

// 查询绩效制度管理-文件列列表
export function listSystemManagementFile(query) {
  return request({
    url: '/kpi/systemManagementFile/list',
    method: 'get',
    params: query
  })
}

// 查询绩效制度管理-文件列详细
export function getSystemManagementFile(id) {
  return request({
    url: '/kpi/systemManagementFile/' + id,
    method: 'get'
  })
}

// 新增绩效制度管理-文件列
export function addSystemManagementFile(data) {
  return request({
    url: '/kpi/systemManagementFile',
    method: 'post',
    data: data
  })
}

// 修改绩效制度管理-文件列
export function updateSystemManagementFile(data) {
  return request({
    url: '/kpi/systemManagementFile/edit',
    method: 'post',
    data: data
  })
}

// 删除绩效制度管理-文件列
export function delSystemManagementFile(id) {
  return request({
    url: '/kpi/systemManagementFile/delete',
    method: 'post',
    data: id
  })
}
