import request from '@/utils/request'

// 登录方法
export function login(tenantId, username, password, code, uuid) {
  return request({
    url: '/auth/login',
    headers: {
      isToken: false
    },
    method: 'post',
    data: { tenantId, username, password, code, uuid }
  })
}

// 注册方法
export function register(data) {
  return request({
    url: '/auth/register',
    headers: {
      isToken: false
    },
    method: 'post',
    data: data
  })
}

// 刷新方法
export function refreshToken() {
  return request({
    url: '/auth/refresh',
    method: 'post'
  })
}

// 获取用户详细信息
export function getInfo() {
  return request({
    url: '/system/user/getInfo',
    method: 'get'
  })
}

// 退出方法
export function logout() {
  return request({
    url: '/auth/delete/logout',
    method: 'post'
  })
}

// 获取验证码
export function getCodeImg() {
  return request({
    url: '/code',
    headers: {
      isToken: false
    },
    method: 'get',
    timeout: 20000
  })
}

// 注册用户字典
export function getRegistDictionary() {
  return request({
    url: '/system/user/getRegistDictionary',
    headers: {
      isToken: false
    },
    method: 'post'
  })
}

// 注册
export function registerUser(data) {
  return request({
    url: '/system/user/registerUser',
    headers: {
      isToken: false
    },
    method: 'post',
    data: data
  })
}
// 查询接口，根据userId
export function submitterList({ userId }) {
  return request({
    url: '/transformationBase/LzStarCommonOrganizationController/submitterList',
    headers: {
      isToken: false
    },
    method: 'get',
    params: { userId }
  })
}

// 激活完善信息用户
export function updatePersonByid(data) {
  return request({
    url: '/transformationBase/LzStarCommonOrganizationController/updatePersonByid',
    headers: {
      isToken: false
    },
    method: 'post',
    data: {
      lzStarCommonOrganizationSubmitter: {
        personType: '2',
        ...data
      }
    }
  })
}

// 发送邮箱接口
export function sendEmail(data) {
  return request({
    url: 'system/user/sendEmail',
    method: 'post',
    data: data
  })
}

// 根据userId查询用户信息接口
export function getUser({ userId }) {
  return request({
    url: 'system/user/getUser',
    method: 'get',
    params: { userId }
  })
}

// 重置密码
export function changePassword(data) {
  return request({
    url: 'system/user/changePassword',
    method: 'post',
    data: data
  })
}

// 微信登录接口
export function wxRender() {
  return request({
    url: 'auth/wechatOauth/render',
    method: 'get'
  })
}

// 获取字典
export const getDictType = dictType => {
  return request(`/system/dict/data/type/${dictType}`, {}, {
    method: 'GET'
  })
}

export function oauth2Login(data) {
  return request({
    url: 'auth/oauthLogin',
    method: 'post',
    data: data
  })
}
