import request from '@/utils/request'

// 查询批量薪资调整列表
export function listBatchSalaryChanges(query) {
  return request({
    url: '/personnelManagement/batchSalaryChanges/list',
    method: 'get',
    params: query
  })
}

// 查询批量薪资调整详细
export function getBatchSalaryChanges(id) {
  return request({
    url: '/personnelManagement/batchSalaryChanges/' + id,
    method: 'get'
  })
}

// 新增批量薪资调整
export function addBatchSalaryChanges(data) {
  return request({
    url: '/personnelManagement/batchSalaryChanges',
    method: 'post',
    data: data
  })
}

// 修改批量薪资调整
export function updateBatchSalaryChanges(data) {
  return request({
    url: '/personnelManagement/batchSalaryChanges/edit',
    method: 'post',
    data: data
  })
}

// 删除批量薪资调整
export function delBatchSalaryChanges(id) {
  return request({
    url: '/personnelManagement/batchSalaryChanges/delete',
    method: 'post',
    data: id
  })
}
