import request from '@/utils/request'

// 查询干部信息列表
export function listInfo(query) {
  return request({
    url: '/personnelManagement/cadre/list',
    method: 'get',
    params: query
  })
}

// 查询干部信息列表
export function listInfoAll(query) {
  return request({
    url: '/personnelManagement/cadre/listAll',
    method: 'get',
    params: query
  })
}

// 查询干部姓名信息列表
export function listInfoName(query) {
  if (query) {
    return request({
      url: `/personnelManagement/cadre/nameList/${query}`,
      method: 'get'
    })
  }
  return request({
    url: '/personnelManagement/cadre/nameList',
    method: 'get'
  })
}

// 查询干部信息详细
export function getInfoCadre(id) {
  return request({
    url: '/personnelManagement/cadre/' + id,
    method: 'get'
  })
}

// 新增干部信息
export function addInfo(data) {
  return request({
    url: '/personnelManagement/cadre',
    method: 'post',
    data: data
  })
}

// 修改干部信息
export function updateInfo(data) {
  return request({
    url: '/personnelManagement/cadre/edit',
    method: 'post',
    data: data
  })
}

// 删除干部信息
export function delInfo(id) {
  return request({
    url: '/personnelManagement/cadre/delete',
    method: 'post',
    data: id
  })
}

export function officerScore(id) {
  return request({
    url: '/personnelManagement/score/scores/' + id,
    method: 'get'
  })
}

export function officerInfo(id) {
  return request({
    url: '/personnelManagement/cadre/simple/' + id,
    method: 'get'
  })
}

export function postScore(id) {
  return request({
    url: '/personnelManagement/score/weight/' + id,
    method: 'get'
  })
}

export function tableScore(id) {
  return request({
    url: '/personnelManagement/score/cadre/' + id,
    method: 'get'
  })
}
