import request from '@/utils/request'

// 查询考评成绩列表
export function listScore(query) {
  return request({
    url: '/personnelManagement/score/list',
    method: 'get',
    params: query
  })
}

// 查询考评成绩详细
export function getScore(id) {
  return request({
    url: '/personnelManagement/score/' + id,
    method: 'get'
  })
}

// 新增考评成绩
export function addScore(data) {
  return request({
    url: '/personnelManagement/score',
    method: 'post',
    data: data
  })
}

// 修改考评成绩
export function updateScore(data) {
  return request({
    url: '/personnelManagement/score/edit',
    method: 'post',
    data: data
  })
}

// 删除考评成绩
export function delScore(id) {
  return request({
    url: '/personnelManagement/score/delete',
    method: 'post',
    data: id
  })
}


