import request from '@/utils/request'

// 查询竞业工资对比列表
export function listCompetitiveSalary(query) {
  return request({
    url: '/personnelManagement/competitiveSalary/list',
    method: 'get',
    params: query
  })
}

// 查询竞业工资对比详细
export function getCompetitiveSalary(id) {
  return request({
    url: '/personnelManagement/competitiveSalary/' + id,
    method: 'get'
  })
}

// 新增竞业工资对比
export function addCompetitiveSalary(data) {
  return request({
    url: '/personnelManagement/competitiveSalary',
    method: 'post',
    data: data
  })
}

// 修改竞业工资对比
export function updateCompetitiveSalary(data) {
  return request({
    url: '/personnelManagement/competitiveSalary/edit',
    method: 'post',
    data: data
  })
}

// 删除竞业工资对比
export function delCompetitiveSalary(id) {
  return request({
    url: '/personnelManagement/competitiveSalary/delete',
    method: 'post',
    data: id
  })
}
