import request from '@/utils/request'

// 查询合同列表
export function listContract(query) {
  return request({
    url: '/personnelManagement/contract/list',
    method: 'get',
    params: query
  })
}

// 查询合同详细
export function getContract(id) {
  return request({
    url: '/personnelManagement/contract/' + id,
    method: 'get'
  })
}

// 新增合同
export function addContract(data) {
  return request({
    url: '/personnelManagement/contract',
    method: 'post',
    data: data
  })
}

// 修改合同
export function updateContract(data) {
  return request({
    url: '/personnelManagement/contract/edit',
    method: 'post',
    data: data
  })
}

// 删除合同
export function delContract(id) {
  return request({
    url: '/personnelManagement/contract/delete',
    method: 'post',
    data: id
  })
}

// 发送合同link
export function sendContractLink(data) {
  return request({
    url: '/personnelManagement/contract/sendContractLink',
    method: 'post',
    data: data
  })
}

export function revokeContract(data) {
  return request({
    url: '/personnelManagement/contract/revoke',
    method: 'post',
    data: data
  })
}
