import request from '@/utils/request'

// 查询合同续约申请列表
export function listContractRenewal(query) {
  return request({
    url: '/personnelManagement/contractRenewal/list',
    method: 'get',
    params: query
  })
}

// 查询合同续约申请详细
export function getContractRenewal(id) {
  return request({
    url: '/personnelManagement/contractRenewal/' + id,
    method: 'get'
  })
}

// 新增合同续约申请
export function addContractRenewal(data) {
  return request({
    url: '/personnelManagement/contractRenewal',
    method: 'post',
    data: data
  })
}

// 修改合同续约申请
export function updateContractRenewal(data) {
  return request({
    url: '/personnelManagement/contractRenewal/edit',
    method: 'post',
    data: data
  })
}

// 删除合同续约申请
export function delContractRenewal(id) {
  return request({
    url: '/personnelManagement/contractRenewal/delete',
    method: 'post',
    data: id
  })
}
