import request from '@/utils/request'

// 查询合同模板列表
export function listContractTemplate(query) {
  return request({
    url: '/personnelManagement/contractTemplate/list',
    method: 'get',
    params: query
  })
}

// 查询合同模板详细
export function getContractTemplate(id) {
  return request({
    url: '/personnelManagement/contractTemplate/' + id,
    method: 'get'
  })
}

// 新增合同模板
export function addContractTemplate(data) {
  return request({
    url: '/personnelManagement/contractTemplate',
    method: 'post',
    data: data
  })
}

// 修改合同模板
export function updateContractTemplate(data) {
  return request({
    url: '/personnelManagement/contractTemplate/edit',
    method: 'post',
    data: data
  })
}

// 删除合同模板
export function delContractTemplate(id) {
  return request({
    url: '/personnelManagement/contractTemplate/delete',
    method: 'post',
    data: id
  })
}

// 启用/停用
export function turnStatusContractTemplate(data) {
  return request({
    url: '/personnelManagement/contractTemplate/turnStatus',
    method: 'post',
    data: data
  })
}

// 获取模版中代替换的标签
export function tagList(data) {
  return request({
    url: '/personnelManagement/contractTemplate/tagList',
    method: 'post',
    data: data
  })
}
