import request from '@/utils/request'

// 查询招聘需求简历确认列表
export function listCvConfirm(query) {
  return request({
    url: '/personnelManagement/cvConfirm/list',
    method: 'get',
    params: query
  })
}

// 查询招聘需求简历确认详细
export function getCvConfirm(id) {
  return request({
    url: '/personnelManagement/cvConfirm/' + id,
    method: 'get'
  })
}

// 新增招聘需求简历确认
export function addCvConfirm(data) {
  return request({
    url: '/personnelManagement/cvConfirm',
    method: 'post',
    data: data
  })
}

// 修改招聘需求简历确认
export function updateCvConfirm(data) {
  return request({
    url: '/personnelManagement/cvConfirm/edit',
    method: 'post',
    data: data
  })
}

// 删除招聘需求简历确认
export function delCvConfirm(id) {
  return request({
    url: '/personnelManagement/cvConfirm/delete',
    method: 'post',
    data: id
  })
}
