import request from '@/utils/request'

// 查询员工拓展属性列表
export function listEmpExtraAttribute(query) {
  return request({
    url: '/personnelManagement/empExtraAttribute/list',
    method: 'get',
    params: query
  })
}

// 查询员工拓展属性详细
export function getEmpExtraAttribute(id) {
  return request({
    url: '/personnelManagement/empExtraAttribute/' + id,
    method: 'get'
  })
}

// 新增员工拓展属性
export function addEmpExtraAttribute(data) {
  return request({
    url: '/personnelManagement/empExtraAttribute',
    method: 'post',
    data: data
  })
}

// 修改员工拓展属性
export function updateEmpExtraAttribute(data) {
  return request({
    url: '/personnelManagement/empExtraAttribute/edit',
    method: 'post',
    data: data
  })
}

// 删除员工拓展属性
export function delEmpExtraAttribute(id) {
  return request({
    url: '/personnelManagement/empExtraAttribute/delete',
    method: 'post',
    data: id
  })
}
