import request from '@/utils/request'

// 查询员工拓展属性值列表
export function listEmpExtraAttributeValue(query) {
  return request({
    url: '/personnelManagement/empExtraAttributeValue/list',
    method: 'get',
    params: query
  })
}

// 查询员工拓展属性值详细
export function getEmpExtraAttributeValue(id) {
  return request({
    url: '/personnelManagement/empExtraAttributeValue/' + id,
    method: 'get'
  })
}

// 新增员工拓展属性值
export function addEmpExtraAttributeValue(data) {
  return request({
    url: '/personnelManagement/empExtraAttributeValue',
    method: 'post',
    data: data
  })
}

// 修改员工拓展属性值
export function updateEmpExtraAttributeValue(data) {
  return request({
    url: '/personnelManagement/empExtraAttributeValue/edit',
    method: 'post',
    data: data
  })
}

// 删除员工拓展属性值
export function delEmpExtraAttributeValue(id) {
  return request({
    url: '/personnelManagement/empExtraAttributeValue/delete',
    method: 'post',
    data: id
  })
}
