import request from '@/utils/request'

// 查询员工拓展模板列表
export function listEmpExtraTemplate(query) {
  return request({
    url: '/personnelManagement/empExtraTemplate/list',
    method: 'get',
    params: query
  })
}

// 查询员工拓展模板详细
export function getEmpExtraTemplate(id) {
  return request({
    url: '/personnelManagement/empExtraTemplate/' + id,
    method: 'get'
  })
}

// 新增员工拓展模板
export function addEmpExtraTemplate(data) {
  return request({
    url: '/personnelManagement/empExtraTemplate',
    method: 'post',
    data: data
  })
}

// 修改员工拓展模板
export function updateEmpExtraTemplate(data) {
  return request({
    url: '/personnelManagement/empExtraTemplate/edit',
    method: 'post',
    data: data
  })
}

// 删除员工拓展模板
export function delEmpExtraTemplate(id) {
  return request({
    url: '/personnelManagement/empExtraTemplate/delete',
    method: 'post',
    data: id
  })
}

// 启停用
export function turnStatusTemplate(data) {
  return request({
    url: '/personnelManagement/empExtraTemplate/turnStatus',
    method: 'post',
    data: data
  })
}

