import request from '@/utils/request'

// 查询员工档案列表
export function listEmployees(query) {
  return request({
    url: '/personnelManagement/employees/list',
    method: 'get',
    params: query
  })
}

// 查询员工档案列表不分页
export function listAllEmployees(query) {
  return request({
    url: '/personnelManagement/employees/listAll',
    method: 'get',
    params: query
  })
}

// 查询员工档案详细
export function getEmployees(id) {
  return request({
    url: '/personnelManagement/employees/' + id,
    method: 'get'
  })
}

// 查询员工档案详细 by code
export function getEmployeesByCode(employeesCode) {
  return request({
    url: '/personnelManagement/employees/getEmployeesByCode/' + employeesCode,
    method: 'get'
  })
}

// 新增员工档案
export function addEmployees(data) {
  return request({
    url: '/personnelManagement/employees',
    method: 'post',
    data: data
  })
}

// 修改员工档案
export function updateEmployees(data) {
  return request({
    url: '/personnelManagement/employees/edit',
    method: 'post',
    data: data
  })
}

// 删除员工档案
export function delEmployees(id) {
  return request({
    url: '/personnelManagement/employees/delete',
    method: 'post',
    data: id
  })
}

// 统计
export function statistics(data) {
  return request({
    url: '/personnelManagement/employees/statistics',
    method: 'post',
    data: data
  })
}

// 成长记录
export function listDisciplinary(query) {
  return request({
    url: '/personnelManagement/employees/listDisciplinary',
    method: 'get',
    params: query
  })
}
// 履历信息
export function jobTransferList(query) {
  return request({
    url: '/personnelManagement/employees/jobTransferList',
    method: 'get',
    params: query
  })
}

// 员工数量
export function employeesCount(data) {
  return request({
    url: '/personnelManagement/employees/employeesCount',
    method: 'post',
    data: data
  })
}


// 获取附件
export function getStreamList(query) {
  return request({
    url: '/personnelManagement/file/streamList',
    method: 'get',
    params: query
  })
}
