import request from '@/utils/request'

// 查询黑名单列表
export function listEmployeesBlackList(query) {
  return request({
    url: '/personnelManagement/employeesBlackList/list',
    method: 'get',
    params: query
  })
}

// 查询黑名单详细
export function getEmployeesBlackList(id) {
  return request({
    url: '/personnelManagement/employeesBlackList/' + id,
    method: 'get'
  })
}

// 新增黑名单
export function addEmployeesBlackList(data) {
  return request({
    url: '/personnelManagement/employeesBlackList',
    method: 'post',
    data: data
  })
}

// 修改黑名单
export function updateEmployeesBlackList(data) {
  return request({
    url: '/personnelManagement/employeesBlackList/edit',
    method: 'post',
    data: data
  })
}

// 删除黑名单
export function delEmployeesBlackList(id) {
  return request({
    url: '/personnelManagement/employeesBlackList/delete',
    method: 'post',
    data: id
  })
}
