import request from '@/utils/request'

// 查询人事异动列表
export function listEmployeesChanges(query) {
  return request({
    url: '/personnelManagement/employeesChanges/list',
    method: 'get',
    params: query
  })
}

// 查询人事异动详细
export function getEmployeesChanges(id) {
  return request({
    url: '/personnelManagement/employeesChanges/' + id,
    method: 'get'
  })
}

// 新增人事异动
export function addEmployeesChanges(data) {
  return request({
    url: '/personnelManagement/employeesChanges',
    method: 'post',
    data: data
  })
}

// 修改人事异动
export function updateEmployeesChanges(data) {
  return request({
    url: '/personnelManagement/employeesChanges/edit',
    method: 'post',
    data: data
  })
}

// 删除人事异动
export function delEmployeesChanges(id) {
  return request({
    url: '/personnelManagement/employeesChanges/delete',
    method: 'post',
    data: id
  })
}

// 人事异动提交审核
export function applyEmployeesChanges(id) {
  return request({
    url: '/personnelManagement/employeesChanges/apply',
    method: 'post',
    data: id
  })
}
