import request from '@/utils/request'

// 查询离职申请列表
export function listEmployeesDepartures(query) {
  return request({
    url: '/personnelManagement/employeesDepartures/list',
    method: 'get',
    params: query
  })
}

// 查询离职申请详细
export function getEmployeesDepartures(id) {
  return request({
    url: '/personnelManagement/employeesDepartures/' + id,
    method: 'get'
  })
}

// 新增离职申请
export function addEmployeesDepartures(data) {
  return request({
    url: '/personnelManagement/employeesDepartures',
    method: 'post',
    data: data
  })
}

// 修改离职申请
export function updateEmployeesDepartures(data) {
  return request({
    url: '/personnelManagement/employeesDepartures/edit',
    method: 'post',
    data: data
  })
}

// 删除离职申请
export function delEmployeesDepartures(id) {
  return request({
    url: '/personnelManagement/employeesDepartures/delete',
    method: 'post',
    data: id
  })
}

// 离职申请apply
export function apply(data) {
  return request({
    url: '/personnelManagement/employeesDepartures/apply',
    method: 'post',
    data: data
  })
}
