import request from '@/utils/request'

// 查询员工奖惩列表
export function listEmployeesDisciplinary(query) {
  return request({
    url: '/personnelManagement/employeesDisciplinary/list',
    method: 'get',
    params: query
  })
}

// 查询员工奖惩详细
export function getEmployeesDisciplinary(id) {
  return request({
    url: '/personnelManagement/employeesDisciplinary/' + id,
    method: 'get'
  })
}

// 新增员工奖惩
export function addEmployeesDisciplinary(data) {
  return request({
    url: '/personnelManagement/employeesDisciplinary',
    method: 'post',
    data: data
  })
}

// 修改员工奖惩
export function updateEmployeesDisciplinary(data) {
  return request({
    url: '/personnelManagement/employeesDisciplinary/edit',
    method: 'post',
    data: data
  })
}

// 删除员工奖惩
export function delEmployeesDisciplinary(id) {
  return request({
    url: '/personnelManagement/employeesDisciplinary/delete',
    method: 'post',
    data: id
  })
}
// 提审
export function applyEmployeesDisciplinary(id) {
  return request({
    url: '/personnelManagement/employeesDisciplinary/apply',
    method: 'post',
    data: id
  })
}

