import request from '@/utils/request'

// 查询员工奖惩ITEM列表
export function listEmployeesDisciplinaryItem(query) {
  return request({
    url: '/personnelManagement/employeesDisciplinaryItem/list',
    method: 'get',
    params: query
  })
}

// 查询员工奖惩ITEM详细
export function getEmployeesDisciplinaryItem(id) {
  return request({
    url: '/personnelManagement/employeesDisciplinaryItem/' + id,
    method: 'get'
  })
}

// 新增员工奖惩ITEM
export function addEmployeesDisciplinaryItem(data) {
  return request({
    url: '/personnelManagement/employeesDisciplinaryItem',
    method: 'post',
    data: data
  })
}

// 修改员工奖惩ITEM
export function updateEmployeesDisciplinaryItem(data) {
  return request({
    url: '/personnelManagement/employeesDisciplinaryItem/edit',
    method: 'post',
    data: data
  })
}

// 删除员工奖惩ITEM
export function delEmployeesDisciplinaryItem(id) {
  return request({
    url: '/personnelManagement/employeesDisciplinaryItem/delete',
    method: 'post',
    data: id
  })
}
