import request from '@/utils/request'

// 查询员工生活物质申请列表
export function listEmployeesLifeMaterial(query) {
  return request({
    url: '/personnelManagement/employeesLifeMaterial/list',
    method: 'get',
    params: query
  })
}

// 查询员工生活物质申请详细
export function getEmployeesLifeMaterial(id) {
  return request({
    url: '/personnelManagement/employeesLifeMaterial/' + id,
    method: 'get'
  })
}

// 新增员工生活物质申请
export function addEmployeesLifeMaterial(data) {
  return request({
    url: '/personnelManagement/employeesLifeMaterial',
    method: 'post',
    data: data
  })
}

// 修改员工生活物质申请
export function updateEmployeesLifeMaterial(data) {
  return request({
    url: '/personnelManagement/employeesLifeMaterial/edit',
    method: 'post',
    data: data
  })
}

// 删除员工生活物质申请
export function delEmployeesLifeMaterial(id) {
  return request({
    url: '/personnelManagement/employeesLifeMaterial/delete',
    method: 'post',
    data: id
  })
}

// 提交员工生活物质申请
export function apply(data) {
  return request({
    url: '/personnelManagement/employeesLifeMaterial/apply',
    method: 'post',
    data: data
  })
}

