import request from '@/utils/request'

// 查询入职申请PM_EMPLOYMENT_APPLICATION列表
export function listEmploymentApplication(query) {
  return request({
    url: '/personnelManagement/employmentApplication/list',
    method: 'get',
    params: query
  })
}

// 查询入职申请PM_EMPLOYMENT_APPLICATION详细
export function getEmploymentApplication(id) {
  return request({
    url: '/personnelManagement/employmentApplication/' + id,
    method: 'get'
  })
}

// 新增入职申请PM_EMPLOYMENT_APPLICATION
export function addEmploymentApplication(data) {
  return request({
    url: '/personnelManagement/employmentApplication',
    method: 'post',
    data: data
  })
}

// 修改入职申请PM_EMPLOYMENT_APPLICATION
export function updateEmploymentApplication(data) {
  return request({
    url: '/personnelManagement/employmentApplication/edit',
    method: 'post',
    data: data
  })
}

// 删除入职申请PM_EMPLOYMENT_APPLICATION
export function delEmploymentApplication(id) {
  return request({
    url: '/personnelManagement/employmentApplication/delete',
    method: 'post',
    data: id
  })
}

// 提交审核
export function applyEmploymentApplication(id) {
  return request({
    url: '/personnelManagement/employmentApplication/apply',
    method: 'post',
    data: id
  })
}

// 查询入职申请PM_EMPLOYMENT_APPLICATION详细
export function getEmploymentApplicationByCvId(cvId) {
  return request({
    url: '/personnelManagement/employmentApplication/getInfoByCvId/' + cvId,
    method: 'get'
  })
}