import request from '@/utils/request'

// 查询招聘需求列表
export function listRecruitmentNeeds(query) {
  return request({
    url: '/personnelManagement/recruitmentNeeds/list',
    method: 'get',
    params: query
  })
}

// 查询招聘需求详细
export function getRecruitmentNeeds(id) {
  return request({
    url: '/personnelManagement/recruitmentNeeds/' + id,
    method: 'get'
  })
}

// 新增招聘需求
export function addRecruitmentNeeds(data) {
  return request({
    url: '/personnelManagement/recruitmentNeeds',
    method: 'post',
    data: data
  })
}

// 修改招聘需求
export function updateRecruitmentNeeds(data) {
  return request({
    url: '/personnelManagement/recruitmentNeeds/edit',
    method: 'post',
    data: data
  })
}

// 删除招聘需求
export function delRecruitmentNeeds(id) {
  return request({
    url: '/personnelManagement/recruitmentNeeds/delete',
    method: 'post',
    data: id
  })
}

// 招聘需求apply
export function applyRecruitmentNeeds(id) {
  return request({
    url: '/personnelManagement/recruitmentNeeds/apply',
    method: 'post',
    data: id
  })
}

// 关闭需求
export function closeRecruitmentNeeds(id) {
  return request({
    url: '/personnelManagement/recruitmentNeeds/close',
    method: 'post',
    data: id
  })
}


