import request from '@/utils/request'

// 查询招聘需求简历列表
export function listRecruitmentNeedsCv(query) {
  return request({
    url: '/personnelManagement/recruitmentNeedsCv/list',
    method: 'get',
    params: query
  })
}

// 查询招聘需求简历详细
export function getRecruitmentNeedsCv(id) {
  return request({
    url: '/personnelManagement/recruitmentNeedsCv/' + id,
    method: 'get'
  })
}

// 新增招聘需求简历
export function addRecruitmentNeedsCv(data) {
  return request({
    url: '/personnelManagement/recruitmentNeedsCv',
    method: 'post',
    data: data
  })
}

// 修改招聘需求简历
export function updateRecruitmentNeedsCv(data) {
  return request({
    url: '/personnelManagement/recruitmentNeedsCv/edit',
    method: 'post',
    data: data
  })
}

// 删除招聘需求简历
export function delRecruitmentNeedsCv(id) {
  return request({
    url: '/personnelManagement/recruitmentNeedsCv/delete',
    method: 'post',
    data: id
  })
}

// 审核招聘需求简历
export function auditRecruitmentNeedsCv(data) {
  return request({
    url: '/personnelManagement/recruitmentNeedsCv/auditRecruitmentNeedsCv',
    method: 'post',
    data: data
  })
}

// 简历状态流转操作
export function flowRecruitmentNeedsCv(data) {
  return request({
    url: '/personnelManagement/recruitmentNeedsCv/flowRecruitmentNeedsCv',
    method: 'post',
    data: data
  })
}

// 修改招聘需求简历
export function updateRecruitmentNeedsCvNoShow(data) {
  return request({
    url: '/personnelManagement/recruitmentNeedsCv/noShow',
    method: 'post',
    data: data
  })
}

// 查询招聘需求简历各状态数量
export function statusNum(data) {
  return request({
    url: '/personnelManagement/recruitmentNeedsCv/statusNum',
    method: 'post',
    data: data
  })
}

// 新增招聘需求简历
export function getNeedsCreateUserByNeedId(data) {
  return request({
    url: '/personnelManagement/recruitmentNeedsCv/getNeedsCreateUserByNeedId',
    method: 'post',
    data: data
  })
}

// 新增招聘需求简历
export function cvFilterAlarm(data) {
  return request({
    url: '/personnelManagement/recruitmentNeedsCv/cvFilterAlarm',
    method: 'post',
    data: data
  })
}

// 获取面试结果确认人
export function getCvConfirmUserByCvId(data) {
  return request({
    url: '/personnelManagement/recruitmentNeedsCv/getCvConfirmUserByCvId',
    method: 'post',
    data: data
  })
}

// 面试结果确认催办
export function cvConfirmUrging(data) {
  return request({
    url: '/personnelManagement/recruitmentNeedsCv/cvConfirmUrging',
    method: 'post',
    data: data
  })
}

