import request from '@/utils/request'

// 查询招聘需求改进列表
export function listTransform(query) {
  return request({
    url: '/personnelManagement/recruitmentNeedsTransform/list',
    method: 'get',
    params: query
  })
}

// 查询招聘需求改进详细
export function getTransform(id) {
  return request({
    url: '/personnelManagement/recruitmentNeedsTransform/' + id,
    method: 'get'
  })
}

// 新增招聘需求改进
export function addTransform(data) {
  return request({
    url: '/personnelManagement/recruitmentNeedsTransform',
    method: 'post',
    data: data
  })
}

// 修改招聘需求改进
export function updateTransform(data) {
  return request({
    url: '/personnelManagement/recruitmentNeedsTransform/edit',
    method: 'post',
    data: data
  })
}

// 删除招聘需求改进
export function delTransform(id) {
  return request({
    url: '/personnelManagement/recruitmentNeedsTransform/delete/' + id,
    method: 'post',
    data: id
  })
}

// 关闭需求
export function closeRecruitmentNeedsTransform(data) {
  return request({
    url: '/personnelManagement/recruitmentNeedsTransform/close',
    method: 'post',
    data: data
  })
}

