import request from '@/utils/request'

// 查询背调信息列表
export function listReferenceCheck(query) {
  return request({
    url: '/personnelManagement/referenceCheck/list',
    method: 'get',
    params: query
  })
}

// 查询背调信息详细
export function getReferenceCheck(id) {
  return request({
    url: '/personnelManagement/referenceCheck/' + id,
    method: 'get'
  })
}

// 新增背调信息
export function addReferenceCheck(data) {
  return request({
    url: '/personnelManagement/referenceCheck',
    method: 'post',
    data: data
  })
}

// 修改背调信息
export function updateReferenceCheck(data) {
  return request({
    url: '/personnelManagement/referenceCheck/edit',
    method: 'post',
    data: data
  })
}

// 删除背调信息
export function delReferenceCheck(id) {
  return request({
    url: '/personnelManagement/referenceCheck/delete',
    method: 'post',
    data: id
  })
}
