import request from '@/utils/request'

// 查询员工任职信息列表
export function listStaffJobInfo(query) {
  return request({
    url: '/personnelManagement/staffJobInfo/list',
    method: 'get',
    params: query
  })
}

// 查询员工任职信息详细
export function getStaffJobInfo(id) {
  return request({
    url: '/personnelManagement/staffJobInfo/' + id,
    method: 'get'
  })
}

// 新增员工任职信息
export function addStaffJobInfo(data) {
  return request({
    url: '/personnelManagement/staffJobInfo',
    method: 'post',
    data: data
  })
}

// 修改员工任职信息
export function updateStaffJobInfo(data) {
  return request({
    url: '/personnelManagement/staffJobInfo/edit',
    method: 'post',
    data: data
  })
}

// 删除员工任职信息
export function delStaffJobInfo(id) {
  return request({
    url: '/personnelManagement/staffJobInfo/delete',
    method: 'post',
    data: id
  })
}


export function statistics(data) {
  return request({
    url: '/personnelManagement/staffJobInfo/statistics',
    method: 'post',
    data: data
  })
}