import request from '@/utils/request'

// 查询离职工作交接列表
export function listWorkHandover(query) {
  return request({
    url: '/personnelManagement/workHandover/list',
    method: 'get',
    params: query
  })
}

// 查询离职工作交接详细
export function getWorkHandover(id) {
  return request({
    url: '/personnelManagement/workHandover/' + id,
    method: 'get'
  })
}

// 新增离职工作交接
export function addWorkHandover(data) {
  return request({
    url: '/personnelManagement/workHandover',
    method: 'post',
    data: data
  })
}

// 修改离职工作交接
export function updateWorkHandover(data) {
  return request({
    url: '/personnelManagement/workHandover/edit',
    method: 'post',
    data: data
  })
}

// 删除离职工作交接
export function delWorkHandover(id) {
  return request({
    url: '/personnelManagement/workHandover/delete',
    method: 'post',
    data: id
  })
}

// 提交
export function applyWorkHandover(id) {
  return request({
    url: '/personnelManagement/workHandover/apply',
    method: 'post',
    data: id
  })
}


