import request from '@/utils/request'

// 查询离职工作交接单列表
export function listWorkHandoverForm(query) {
  return request({
    url: '/personnelManagement/workHandoverForm/list',
    method: 'get',
    params: query
  })
}

// 查询离职工作交接单详细
export function getWorkHandoverForm(id) {
  return request({
    url: '/personnelManagement/workHandoverForm/' + id,
    method: 'get'
  })
}

// 新增离职工作交接单
export function addWorkHandoverForm(data) {
  return request({
    url: '/personnelManagement/workHandoverForm',
    method: 'post',
    data: data
  })
}

// 修改离职工作交接单
export function updateWorkHandoverForm(data) {
  return request({
    url: '/personnelManagement/workHandoverForm/edit',
    method: 'post',
    data: data
  })
}

// 删除离职工作交接单
export function delWorkHandoverForm(id) {
  return request({
    url: '/personnelManagement/workHandoverForm/delete',
    method: 'post',
    data: id
  })
}
