import request from '@/utils/request'

// 查询离职工作交接项确认列表
export function listWorkHandoverItemConfirm(query) {
  return request({
    url: '/personnelManagement/workHandoverItemConfirm/list',
    method: 'get',
    params: query
  })
}

// 查询离职工作交接项确认详细
export function getWorkHandoverItemConfirm(id) {
  return request({
    url: '/personnelManagement/workHandoverItemConfirm/' + id,
    method: 'get'
  })
}

// 新增离职工作交接项确认
export function addWorkHandoverItemConfirm(data) {
  return request({
    url: '/personnelManagement/workHandoverItemConfirm',
    method: 'post',
    data: data
  })
}

// 修改离职工作交接项确认
export function updateWorkHandoverItemConfirm(data) {
  return request({
    url: '/personnelManagement/workHandoverItemConfirm/edit',
    method: 'post',
    data: data
  })
}

// 删除离职工作交接项确认
export function delWorkHandoverItemConfirm(id) {
  return request({
    url: '/personnelManagement/workHandoverItemConfirm/delete',
    method: 'post',
    data: id
  })
}

// 离职工作交接项确认
export function confirmWorkHandoverItemConfirm(data) {
  return request({
    url: '/personnelManagement/workHandoverItemConfirm/confirm',
    method: 'post',
    data: data
  })
}

// 转交工作交接项确认
export function transferWorkHandoverItemConfirm(data) {
  return request({
    url: '/personnelManagement/workHandoverItemConfirm/transfer',
    method: 'post',
    data: data
  })
}