import request from '@/utils/request'

// 查询坏账扣款列表
export function listBadDebtDeduction(query) {
  return request({
    url: '/salary/badDebtDeduction/list',
    method: 'get',
    params: query
  })
}

// 查询坏账扣款详细
export function getBadDebtDeduction(id) {
  return request({
    url: '/salary/badDebtDeduction/' + id,
    method: 'get'
  })
}

// 新增坏账扣款
export function addBadDebtDeduction(data) {
  return request({
    url: '/salary/badDebtDeduction',
    method: 'post',
    data: data
  })
}

// 修改坏账扣款
export function updateBadDebtDeduction(data) {
  return request({
    url: '/salary/badDebtDeduction/edit',
    method: 'post',
    data: data
  })
}

// 删除坏账扣款
export function delBadDebtDeduction(id) {
  return request({
    url: '/salary/badDebtDeduction/delete',
    method: 'post',
    data: id
  })
}
