import request from '@/utils/request'

// 查询工衣扣还费用列表
export function listClothingCosts(query) {
  return request({
    url: '/salary/clothingCosts/list',
    method: 'get',
    params: query
  })
}

// 查询工衣扣还费用详细
export function getClothingCosts(id) {
  return request({
    url: '/salary/clothingCosts/' + id,
    method: 'get'
  })
}

// 新增工衣扣还费用
export function addClothingCosts(data) {
  return request({
    url: '/salary/clothingCosts',
    method: 'post',
    data: data
  })
}

// 修改工衣扣还费用
export function updateClothingCosts(data) {
  return request({
    url: '/salary/clothingCosts/edit',
    method: 'post',
    data: data
  })
}

// 删除工衣扣还费用
export function delClothingCosts(id) {
  return request({
    url: '/salary/clothingCosts/delete',
    method: 'post',
    data: id
  })
}
