import request from '@/utils/request'

// 查询离职工资计算列表
export function listGzCalcResigned(query) {
  return request({
    url: '/salary/gzCalcResigned/list',
    method: 'get',
    params: query
  })
}

// 查询离职工资计算详细
export function getGzCalcResigned(id) {
  return request({
    url: '/salary/gzCalcResigned/' + id,
    method: 'get'
  })
}

// 新增离职工资计算
export function addGzCalcResigned(data) {
  return request({
    url: '/salary/gzCalcResigned',
    method: 'post',
    data: data
  })
}

// 修改离职工资计算
export function updateGzCalcResigned(data) {
  return request({
    url: '/salary/gzCalcResigned/edit',
    method: 'post',
    data: data
  })
}

// 删除离职工资计算
export function delGzCalcResigned(id) {
  return request({
    url: '/salary/gzCalcResigned/delete',
    method: 'post',
    data: id
  })
}

// 查询全部离职员工
export function getResignedEmployees(query) {
  return request({
    url: '/salary/gzCalcResigned/getResignedEmployees',
    method: 'get',
    params: query
  })
}

// 查询离职工资详情明细
export function getDetail(query) {
  return request({
    url: '/salary/gzCalcResigned/getDetail',
    method: 'get',
    params: query
  })
}

// 重新计算
export function recalculateSalary(data) {
  return request({
    url: '/salary/gzCalcResigned/recalculateSalary',
    method: 'post',
    data: data
  })
}

export function editSalaryRow(data) {
  return request({
    url: '/salary/gzCalcResigned/editSalaryRow',
    method: 'post',
    data: data
  })
}

export function startAudit(data) {
  return request({
    url: '/salary/gzCalcResigned/startAudit',
    method: 'post',
    data: data
  })
}
