import request from '@/utils/request'

// 查询工资确认列表
export function listGzConfirm(query) {
  return request({
    url: '/salary/gzConfirm/list',
    method: 'get',
    params: query
  })
}

// 查询工资确认详细
export function getGzConfirm(id) {
  return request({
    url: '/salary/gzConfirm/' + id,
    method: 'get'
  })
}

// 新增工资确认
export function addGzConfirm(data) {
  return request({
    url: '/salary/gzConfirm',
    method: 'post',
    data: data
  })
}

// 修改工资确认
export function updateGzConfirm(data) {
  return request({
    url: '/salary/gzConfirm/edit',
    method: 'post',
    data: data
  })
}

// 删除工资确认
export function delGzConfirm(id) {
  return request({
    url: '/salary/gzConfirm/delete',
    method: 'post',
    data: id
  })
}

export function confirmedIds(query) {
  return request({
    url: '/salary/gzConfirm/confirmedIds',
    method: 'get',
    params: query
  })
}

export function dataListByConfirmId(query) {
  return request({
    url: '/salary/gzConfirm/dataListByConfirmId',
    method: 'get',
    params: query
  })
}

// 查询工资确认列表
export function listGzConfirmByCalcId(query) {
  return request({
    url: '/salary/gzConfirm/listGzConfirmByCalcId',
    method: 'get',
    params: query
  })
}

// 新增绩效确认
export function addByCommand(data) {
  return request({
    url: '/salary/gzConfirm/addByCommand',
    method: 'post',
    data: data
  })
}

export function hasSetPassword(data) {
  return request({
    url: '/salary/gzPassword/hasSetPassword',
    method: 'post',
    data: data
  })
}

export function initPassword(data) {
  return request({
    url: '/salary/gzPassword/initPassword',
    method: 'post',
    data: data
  })
}

export function changePassword(data) {
  return request({
    url: '/salary/gzPassword/changePassword',
    method: 'post',
    data: data
  })
}

export function verifyPassword(data) {
  return request({
    url: '/salary/gzPassword/verifyPassword',
    method: 'post',
    data: data
  })
}

// 重新绩效确认
export function reAddGzConfirm(data) {
  return request({
    url: '/salary/gzConfirm/reAddGzConfirm',
    method: 'post',
    data: data
  })
}
