import request from '@/utils/request'

// 查询个税计算记录列表
export function listGzPersonalTax(query) {
  return request({
    url: '/salary/gzPersonalTax/list',
    method: 'get',
    params: query
  })
}

// 查询个税计算记录详细
export function getGzPersonalTax(id) {
  return request({
    url: '/salary/gzPersonalTax/' + id,
    method: 'get'
  })
}

// 新增个税计算记录
export function addGzPersonalTax(data) {
  return request({
    url: '/salary/gzPersonalTax',
    method: 'post',
    data: data
  })
}

// 修改个税计算记录
export function updateGzPersonalTax(data) {
  return request({
    url: '/salary/gzPersonalTax/edit',
    method: 'post',
    data: data
  })
}

// 删除个税计算记录
export function delGzPersonalTax(id) {
  return request({
    url: '/salary/gzPersonalTax/delete',
    method: 'post',
    data: id
  })
}
