import request from '@/utils/request'

// 查询工资厂区导入扣款列表
export function listImportFDeduction(query) {
  return request({
    url: '/salary/importFDeduction/list',
    method: 'get',
    params: query
  })
}

// 查询工资厂区导入扣款详细
export function getImportFDeduction(id) {
  return request({
    url: '/salary/importFDeduction/' + id,
    method: 'get'
  })
}

// 新增工资厂区导入扣款
export function addImportFDeduction(data) {
  return request({
    url: '/salary/importFDeduction',
    method: 'post',
    data: data
  })
}

// 修改工资厂区导入扣款
export function updateImportFDeduction(data) {
  return request({
    url: '/salary/importFDeduction/edit',
    method: 'post',
    data: data
  })
}

// 删除工资厂区导入扣款
export function delImportFDeduction(id) {
  return request({
    url: '/salary/importFDeduction/delete',
    method: 'post',
    data: id
  })
}
