import request from '@/utils/request'

// 查询工资厂区导入计件工资列表
export function listImportFPieceRate(query) {
  return request({
    url: '/salary/importFPieceRate/list',
    method: 'get',
    params: query
  })
}

// 查询工资厂区导入计件工资详细
export function getImportFPieceRate(id) {
  return request({
    url: '/salary/importFPieceRate/' + id,
    method: 'get'
  })
}

// 新增工资厂区导入计件工资
export function addImportFPieceRate(data) {
  return request({
    url: '/salary/importFPieceRate',
    method: 'post',
    data: data
  })
}

// 修改工资厂区导入计件工资
export function updateImportFPieceRate(data) {
  return request({
    url: '/salary/importFPieceRate/edit',
    method: 'post',
    data: data
  })
}

// 删除工资厂区导入计件工资
export function delImportFPieceRate(id) {
  return request({
    url: '/salary/importFPieceRate/delete',
    method: 'post',
    data: id
  })
}
