import request from '@/utils/request'

// 查询工资厂区导入补贴列表
export function listImportFSubsidy(query) {
  return request({
    url: '/salary/importFSubsidy/list',
    method: 'get',
    params: query
  })
}

// 查询工资厂区导入补贴详细
export function getImportFSubsidy(id) {
  return request({
    url: '/salary/importFSubsidy/' + id,
    method: 'get'
  })
}

// 新增工资厂区导入补贴
export function addImportFSubsidy(data) {
  return request({
    url: '/salary/importFSubsidy',
    method: 'post',
    data: data
  })
}

// 修改工资厂区导入补贴
export function updateImportFSubsidy(data) {
  return request({
    url: '/salary/importFSubsidy/edit',
    method: 'post',
    data: data
  })
}

// 删除工资厂区导入补贴
export function delImportFSubsidy(id) {
  return request({
    url: '/salary/importFSubsidy/delete',
    method: 'post',
    data: id
  })
}
