import request from '@/utils/request'

// 查询工资厂区导入工伤列表
export function listImportFWorkInjury(query) {
  return request({
    url: '/salary/importFWorkInjury/list',
    method: 'get',
    params: query
  })
}

// 查询工资厂区导入工伤详细
export function getImportFWorkInjury(id) {
  return request({
    url: '/salary/importFWorkInjury/' + id,
    method: 'get'
  })
}

// 新增工资厂区导入工伤
export function addImportFWorkInjury(data) {
  return request({
    url: '/salary/importFWorkInjury',
    method: 'post',
    data: data
  })
}

// 修改工资厂区导入工伤
export function updateImportFWorkInjury(data) {
  return request({
    url: '/salary/importFWorkInjury/edit',
    method: 'post',
    data: data
  })
}

// 删除工资厂区导入工伤
export function delImportFWorkInjury(id) {
  return request({
    url: '/salary/importFWorkInjury/delete',
    method: 'post',
    data: id
  })
}
